import os
from qgis.PyQt.QtCore import QObject
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from qgis.core import QgsProject
from qgis.utils import iface

class SimplePlugin(QObject):
    def __init__(self, iface):
        super().__init__()
        self.iface = iface
        self.action = None

    def initGui(self):
        # アイコンのパスを正しく設定
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        icon = QIcon(icon_path)
        self.action = QAction(icon, "Show Layer Info", self.iface.mainWindow())
        self.action.triggered.connect(self.show_layer_info)
        self.iface.addPluginToMenu("Simple Plugin", self.action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        self.iface.removePluginMenu("Simple Plugin", self.action)
        self.iface.removeToolBarIcon(self.action)

    def show_layer_info(self):
        # 現在選択されているレイヤーを取得
        layer = self.iface.activeLayer()
        if not layer:
            QMessageBox.information(self.iface.mainWindow(), "No Layer", "Please select a layer.")
            return

        # レイヤー情報を表示
        layer_info = f"Layer name: {layer.name()}\\nLayer type: {layer.type()}"
        QMessageBox.information(self.iface.mainWindow(), "Layer Info", layer_info)

def classFactory(iface):
    return SimplePlugin(iface)
